;;;
;;; Copyright (c) 2010, Lorenz Moesenlechner <moesenle@in.tum.de>
;;; All rights reserved.
;;; 
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions are met:
;;; 
;;;     * Redistributions of source code must retain the above copyright
;;;       notice, this list of conditions and the following disclaimer.
;;;     * Redistributions in binary form must reproduce the above copyright
;;;       notice, this list of conditions and the following disclaimer in the
;;;       documentation and/or other materials provided with the distribution.
;;;     * Neither the name of Willow Garage, Inc. nor the names of its
;;;       contributors may be used to endorse or promote products derived from
;;;       this software without specific prior written permission.
;;; 
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
;;; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
;;; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
;;; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
;;; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
;;; CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
;;; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
;;; POSSIBILITY OF SUCH DAMAGE.
;;;

(defsystem cram-pick-and-place
  :author "Lorenz Moesenlechner"
  :license "BSD"
  :description "Tutorial for cram language in pick-and-place tasks"

  :depends-on (cram-language
               cram-roslisp-common
               cram-execution-trace
               cram-plan-knowledge
               actionlib
               move_base_msgs-msg
               pr2_controllers_msgs-msg
               cotesys_ros_grasping-msg
               pr2_common_action_msgs-msg
               approach_table_tools-srv
               table_objects-srv
               gazebo-msg)
  :components
  ((:module "src"
            :components
            ((:file "package")
             (:file "navigation" :depends-on ("package" "utils"))
             (:file "spine" :depends-on ("package"))
             (:file "grasping" :depends-on ("package"))
             (:file "perception" :depends-on ("package" "utils"))
             (:file "utils" :depends-on ("package"))))
   (:module "tutorial"
            :depends-on ("src")
            :components
            ((:file "plans")
             (:file "transparent-plans" :depends-on ("plans"))))))
