(in-ns 'edu.berkeley.ai.util)

(defmacro assert-is
  "Like assert, but prints some more info about the offending form (may multiple eval on error)"
  ([form] `(assert-is ~form ""))
  ([form format-str & args]
     `(when-not ~form
	(throw (Exception. (str (format ~format-str ~@args) 
				": Got " '~form " as " (cons '~(first form) (list ~@(next form)))))))))

(def *bad-form* (atom nil))
(defmacro make-safe 
  ([x] `(make-safe ~x ""))
  ([x format-str & args]
     `(let [x# ~x]
	(when-not x# 
	  (swap! *bad-form* (constantly (list ~@x)))
	  (throw (Exception. (str (format ~format-str ~@args) 
					     ": False/nil " x# " from " '~x " as " (cons '~(first x) (list ~@(next x)))))))
	x#)))

