(in-ns 'edu.berkeley.ai.util)

(defn map-map "Like map, but expects f to return pairs/map entries that are combined to make a map return value."
  [f & maps] (into {} (apply map f maps)))
     ;(reduce #(conj %1 %2) {} (apply map f maps)))


(defn map-keys [f m]
  (into {} (map (fn [[k v]] [(f k) v]) m)))

(defn map-vals [f m]
  (into {} (map (fn [[k v]] [k (f v)]) m)))

(defn filter-map [f m]
  (reduce (fn [m e] (if (f e) m (dissoc m (key e))))
	  m m))

(defmacro lazy-get "Like get but lazy about default"
  [m k d]
  `(if-let [pair# (find ~m ~k)] 
       (val pair#)
     ~d))

(defn safe-get "Like get but throw an exception if not found"
  [m k] 
  (lazy-get m k (throw (IllegalArgumentException. (format "Key %s not found in %s" k m)))))

(defn safe-get-in 
  [m ks]
  (if (seq ks) 
      (recur (safe-get m (first ks)) (next ks))
    m))

 
(defn merge-disjoint [m1 m2]
  (let [ret (merge m1 m2)]
    (assert-is (= (count ret) (+ (count m1) (count m2))))
    ret))

(defn merge-with-pred 
  "Like merge-with, but takes a predicate on values and keeps the best one.
   Also preserves the metadata on the key associated with the best value."
  ([pred] {})
  ([pred m] m)
  ([pred m & maps]
     (persistent!
      (reduce 
       (fn [tm1 [k v]]
         (if-let [[_ ov] (let [v (get tm1 k :G___123123)] (when-not (= v :G___123123) [nil v]))]
                          ;; Horrible hack since find doens't work on transients.
             (if (pred v ov) (assoc! (dissoc! tm1 k) k v) tm1)
           (assoc! tm1 k v)))
       (transient m) (apply concat maps)))))
	      
(defn keyset [m] (set (keys m)))

(defn trans-map "Get a map representing the (safe) composition of m1 and m2" [m1 m2]
  (map-vals #(safe-get m2 %) m1))
