(in-ns 'edu.berkeley.ai.util)

(defn git-commit-id []
  (aget (.split #^String (sh "git" "log" "-1" :dir (root-local "")) "\n") 0))

(defn single-quote [s] (str "'" s "'"))

(defn double-quote [s] (str "\"" s "\""))

(defmacro with-out-str2
  "Evaluates exprs in a context in which *out* is bound to a fresh
  StringWriter.  Returns [return-val, string]"
  [& body]
  `(let [s# (new java.io.StringWriter)]
     (binding [*out* s#]
       [(do ~@body) (str s#)])))

(defn prln "Print all arguments and return the first argument"
  [& args] (do (println (apply print-str args)) (first args)))

(defmacro trace-expr "Trace a single expression, printing info about args and return. Will remove shortcuts"
  ([expr] 
     `(do
        (let [args# (list ~@(next expr))]
	  (print "Entering " (cons '~(first expr) args#) "...\n")
	  (let [result# (apply ~(first expr) args#)]
	    (print "Leaving " (cons '~(first expr) args#) ", got " result# ".\n")
	    result#)))))

(defn sref-set! [sref val] 
  (reset! sref val))

(defn sref-get [sref]
  @sref)

(defn sref-up! [sref fn & args]
  (reset! sref (apply fn @sref args)))

(defn sref "A non-thread-safe, reasonably fast mutable reference"
  ([] (sref nil))
  ([init] (atom init)))

(defn counter-from [x]
  (let [c (sref (dec x))]
     #(sref-up! c inc)))
