(in-ns 'edu.berkeley.ai.util)

(defn third [s] (nth s 2))

(defn maximal-elements [f s]
  "Return a seq of elements of s maximizing (f elt)."
  (when (seq s)
    (loop [max-elts [(first s)], 
	   max-val (f (first s)),
	   rest-elts (next s)]
      (if (empty? rest-elts) 
	  max-elts
	(let [next-val (f (first rest-elts))]
	  (cond (< next-val max-val) (recur max-elts max-val (next rest-elts))
		(= next-val max-val) (recur (cons (first rest-elts) max-elts) max-val (next rest-elts))
		(> next-val max-val) (recur [(first rest-elts)] next-val (next rest-elts))))))))

(defn first-maximal-element [f s]
  "Return the first element of s maximizing (f elt), throwing an exception if s empty."
  (first (make-safe (maximal-elements f s))))

(defn random-maximal-element [f s]
  "Return a random element of s maximizing (f elt), throwing an exception if s empty."
  (rand-elt (make-safe (maximal-elements f s))))
	   
(defn distinct-elts? [s] 
  (or (empty? s) (apply distinct? s)))

(defn iterate-while [f x]
  (take-while identity (iterate f x)))

(defn reduce-while [f a c]
  (when a 
    (if (empty? c) a
      (recur f (f a (first c)) (rest c)))))


(defn to-set [x]
  (if (set? x) x (set x))) 

(defn to-vec [x] 
  (if (vector? x) x (vec x)))

(defn count-when [f c]
  (reduce (fn [v i] (if (f i) (inc v) v)) 0 c))

(defn singleton? [c] 
  (= (count c) 1))

(defn singleton [c]
  (when (singleton? c) (first c)))

(defn safe-singleton [c]
  (assert-is (singleton? c))
  (first c))

