(ns exp.sahtn-dijkstra
  (:require [edu.berkeley.ai.util :as util]
            [edu.berkeley.ai.util.queues :as queues]
            [exp [env :as env] [hierarchy :as hierarchy]])
  (:import [java.util HashMap])
  )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                    SAHTN-Dijkstra
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(declare sahtn-action)

(defn- sahtn-do-action [cache s a]
  "Return a map from (possibly abstracted) outcome states 
   (with local solutions as metadata) to rewards.
   Takes (possibly abstracted) states as input."
  (cond (env/primitive? a)
          (if-let [[ss r]  (and (env/applicable? a s) (env/successor a s))] {(vary-meta ss assoc :opt [a]) r} {})
        (hierarchy/cycle-level a s)                       ; loopy!
          (let [level  (hierarchy/cycle-level a s)
                q      (queues/make-graph-search-pq)
                result (HashMap.)]
            (queues/pq-add! q [s [a]] 0)
            (while (not (queues/pq-empty? q))
              (let [[[s a] c] (queues/pq-remove-min-with-cost! q)]
                (if (empty? a) 
                    (.put result s (- c))
                  (let [[f & r] a
                        f-level (hierarchy/cycle-level f s)]
                    (assert (or (not f-level) (<= f-level level)))
                    (if (or (not f-level) (< f-level level))
                        (doseq [[ss sr] (sahtn-action cache s f (- c))]
                           (queues/pq-add! q [ss r] (- sr)))
                      (doseq [ref (hierarchy/immediate-refinements f s)]
                         (queues/pq-add! q [s (concat ref r)] c)))))))
            (into {} result))
        :else
           (apply util/merge-with-pred > 
                (for [ref (hierarchy/immediate-refinements a s)]
                  (reduce (fn [cv a] 
                            (apply util/merge-with-pred >  
                                   (for [[s r] cv] (sahtn-action cache s a r))))
                          {s 0} ref)))))


(defn- sahtn-action [#^HashMap cache s a r]
  "Handling caching and stitching states, etc."
  (let [context-schema  (env/precondition-context a s)
        context         (env/extract-context s context-schema)
	cache-key       [(env/action-name a) context]
	cache-val       (.get cache cache-key)]
    (util/map-map 
        (fn [[effect-map local-reward]]
          [(vary-meta (env/apply-effects s effect-map)
                      assoc :opt (concat (:opt (meta s)) (:opt (meta effect-map))))
           (+ r local-reward)])
        (or cache-val
            (let [result
                  (util/map-keys
                   (fn [outcome-state]
                     (with-meta (env/extract-effects outcome-state context-schema) 
                       (select-keys (meta outcome-state) [:opt]))) 
                   (sahtn-do-action cache (env/get-logger s) a))]
              (.put cache cache-key result)
              result)))))




(defn sahtn-dijkstra [henv]
  (let [e       (hierarchy/env henv)
        cache   (HashMap.)
        results (sahtn-action cache (env/initial-state e) (hierarchy/TopLevelAction e [(hierarchy/initial-plan henv)]) 0)]
    (when-not (empty? results)
      (let [[k v] (util/first-maximal-element val results)]
        [(:opt (meta k)) v]))))

