(ns exp.sahtn-nr
  (:require [edu.berkeley.ai.util :as util]
            [exp [env :as env] [hierarchy :as hierarchy]])
  (:import [java.util HashMap])
  )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                    SAHTN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; This version will loop forever on recursive hierarchies


(declare sahtn-action)

(defn- sahtn-do-action [cache s a]
  "Return a map from (possibly abstracted) outcome states 
   (with local solutions as metadata) to rewards.
   Takes (possibly abstracted) states as input."
  (if (env/primitive? a)
    (if-let [[ss r] (and (env/applicable? a s) (env/successor a s))] 
        {(vary-meta ss assoc :opt [a]) r} {})
      (apply util/merge-with-pred > 
        (for [ref (hierarchy/immediate-refinements a s)]
          (reduce (fn [cv a] 
                    (apply util/merge-with-pred >  
                           (for [[s r] cv] (sahtn-action cache s a r))))
                  {s 0} ref)))))


(defn- sahtn-action [#^HashMap cache s a r]
  "Handling caching and stitching states, etc."
  (let [context-schema  (env/precondition-context a s)
        context         (env/extract-context s context-schema)
	cache-key       [(env/action-name a) context]
	cache-val       (.get cache cache-key)]
    (util/map-map 
        (fn [[effect-map local-reward]]
          [(vary-meta (env/apply-effects s effect-map)
                      assoc :opt (concat (:opt (meta s)) (:opt (meta effect-map))))
           (+ r local-reward)])
        (or cache-val
            (let [result
                  (util/map-keys
                   (fn [outcome-state]
                     (with-meta (env/extract-effects outcome-state context-schema) 
                       (select-keys (meta outcome-state) [:opt]))) 
                   (sahtn-do-action cache (env/get-logger s) a))]
              (.put cache cache-key result)
              result)))))


(defn sahtn-nr [henv]
  (let [e       (hierarchy/env henv)
        cache   (HashMap.)
        results (sahtn-action cache (env/initial-state e) (hierarchy/TopLevelAction e [(hierarchy/initial-plan henv)]) 0)]
    (when-not (empty? results)    
;      (assert (= (count results) 1))
      (let [[k v] (util/first-maximal-element val results)]
        [(:opt (meta k)) v]))))


